package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteDiskRequest(
    diskName: ResourceName,
    forceDeleteAddOns: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest = {
    import DeleteDiskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest
      .builder()
      .diskName(ResourceName.unwrap(diskName): java.lang.String)
      .optionallyWith(forceDeleteAddOns.map(value => value: java.lang.Boolean))(
        _.forceDeleteAddOns
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteDiskRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteDiskRequest.wrap(buildAwsValue())
}
object DeleteDiskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteDiskRequest =
      zio.aws.lightsail.model
        .DeleteDiskRequest(diskName, forceDeleteAddOns.map(value => value))
    def diskName: ResourceName
    def forceDeleteAddOns: Option[Boolean]
    def getDiskName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(diskName)
    def getForceDeleteAddOns: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceDeleteAddOns", forceDeleteAddOns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest
  ) extends zio.aws.lightsail.model.DeleteDiskRequest.ReadOnly {
    override val diskName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.diskName())
    override val forceDeleteAddOns: Option[Boolean] =
      scala.Option(impl.forceDeleteAddOns()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest
  ): zio.aws.lightsail.model.DeleteDiskRequest.ReadOnly = new Wrapper(impl)
}
