package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteDistributionResponse(
    operation: Option[zio.aws.lightsail.model.Operation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteDistributionResponse = {
    import DeleteDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteDistributionResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteDistributionResponse.ReadOnly =
    zio.aws.lightsail.model.DeleteDistributionResponse.wrap(buildAwsValue())
}
object DeleteDistributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteDistributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteDistributionResponse =
      zio.aws.lightsail.model
        .DeleteDistributionResponse(operation.map(value => value.asEditable))
    def operation: Option[zio.aws.lightsail.model.Operation.ReadOnly]
    def getOperation
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDistributionResponse
  ) extends zio.aws.lightsail.model.DeleteDistributionResponse.ReadOnly {
    override val operation: Option[zio.aws.lightsail.model.Operation.ReadOnly] =
      scala
        .Option(impl.operation())
        .map(value => zio.aws.lightsail.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDistributionResponse
  ): zio.aws.lightsail.model.DeleteDistributionResponse.ReadOnly = new Wrapper(
    impl
  )
}
