package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteKeyPairRequest(keyPairName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest = {
    import DeleteKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest
      .builder()
      .keyPairName(ResourceName.unwrap(keyPairName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteKeyPairRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteKeyPairRequest.wrap(buildAwsValue())
}
object DeleteKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteKeyPairRequest =
      zio.aws.lightsail.model.DeleteKeyPairRequest(keyPairName)
    def keyPairName: ResourceName
    def getKeyPairName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(keyPairName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest
  ) extends zio.aws.lightsail.model.DeleteKeyPairRequest.ReadOnly {
    override val keyPairName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.keyPairName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest
  ): zio.aws.lightsail.model.DeleteKeyPairRequest.ReadOnly = new Wrapper(impl)
}
