package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DestinationInfo(
    id: Option[NonEmptyString] = None,
    service: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DestinationInfo = {
    import DestinationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DestinationInfo
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        service.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.service)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DestinationInfo.ReadOnly =
    zio.aws.lightsail.model.DestinationInfo.wrap(buildAwsValue())
}
object DestinationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DestinationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DestinationInfo =
      zio.aws.lightsail.model
        .DestinationInfo(id.map(value => value), service.map(value => value))
    def id: Option[NonEmptyString]
    def service: Option[NonEmptyString]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getService: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("service", service)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DestinationInfo
  ) extends zio.aws.lightsail.model.DestinationInfo.ReadOnly {
    override val id: Option[NonEmptyString] = scala
      .Option(impl.id())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val service: Option[NonEmptyString] = scala
      .Option(impl.service())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DestinationInfo
  ): zio.aws.lightsail.model.DestinationInfo.ReadOnly = new Wrapper(impl)
}
