package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{Integer, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DiskInfo(
    name: Option[String] = None,
    path: Option[NonEmptyString] = None,
    sizeInGb: Option[Integer] = None,
    isSystemDisk: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DiskInfo = {
    import DiskInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DiskInfo
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        sizeInGb.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.sizeInGb)
      .optionallyWith(isSystemDisk.map(value => value: java.lang.Boolean))(
        _.isSystemDisk
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DiskInfo.ReadOnly =
    zio.aws.lightsail.model.DiskInfo.wrap(buildAwsValue())
}
object DiskInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DiskInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DiskInfo =
      zio.aws.lightsail.model.DiskInfo(
        name.map(value => value),
        path.map(value => value),
        sizeInGb.map(value => value),
        isSystemDisk.map(value => value)
      )
    def name: Option[String]
    def path: Option[NonEmptyString]
    def sizeInGb: Option[Integer]
    def isSystemDisk: Option[Boolean]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
    def getSizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInGb", sizeInGb)
    def getIsSystemDisk: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSystemDisk", isSystemDisk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DiskInfo
  ) extends zio.aws.lightsail.model.DiskInfo.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val path: Option[NonEmptyString] = scala
      .Option(impl.path())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val sizeInGb: Option[Integer] = scala
      .Option(impl.sizeInGb())
      .map(value => zio.aws.lightsail.model.primitives.Integer(value))
    override val isSystemDisk: Option[Boolean] =
      scala.Option(impl.isSystemDisk()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DiskInfo
  ): zio.aws.lightsail.model.DiskInfo.ReadOnly = new Wrapper(impl)
}
