package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DiskSnapshotInfo(sizeInGb: Option[Integer] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo = {
    import DiskSnapshotInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo
      .builder()
      .optionallyWith(
        sizeInGb.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.sizeInGb)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DiskSnapshotInfo.ReadOnly =
    zio.aws.lightsail.model.DiskSnapshotInfo.wrap(buildAwsValue())
}
object DiskSnapshotInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DiskSnapshotInfo =
      zio.aws.lightsail.model.DiskSnapshotInfo(sizeInGb.map(value => value))
    def sizeInGb: Option[Integer]
    def getSizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInGb", sizeInGb)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo
  ) extends zio.aws.lightsail.model.DiskSnapshotInfo.ReadOnly {
    override val sizeInGb: Option[Integer] = scala
      .Option(impl.sizeInGb())
      .map(value => zio.aws.lightsail.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo
  ): zio.aws.lightsail.model.DiskSnapshotInfo.ReadOnly = new Wrapper(impl)
}
