package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{NonEmptyString, IsoDate}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ExportSnapshotRecordSourceInfo(
    resourceType: Option[
      zio.aws.lightsail.model.ExportSnapshotRecordSourceType
    ] = None,
    createdAt: Option[IsoDate] = None,
    name: Option[NonEmptyString] = None,
    arn: Option[NonEmptyString] = None,
    fromResourceName: Option[NonEmptyString] = None,
    fromResourceArn: Option[NonEmptyString] = None,
    instanceSnapshotInfo: Option[zio.aws.lightsail.model.InstanceSnapshotInfo] =
      None,
    diskSnapshotInfo: Option[zio.aws.lightsail.model.DiskSnapshotInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo = {
    import ExportSnapshotRecordSourceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        fromResourceName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.fromResourceName)
      .optionallyWith(
        fromResourceArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.fromResourceArn)
      .optionallyWith(instanceSnapshotInfo.map(value => value.buildAwsValue()))(
        _.instanceSnapshotInfo
      )
      .optionallyWith(diskSnapshotInfo.map(value => value.buildAwsValue()))(
        _.diskSnapshotInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.ExportSnapshotRecordSourceInfo.ReadOnly =
    zio.aws.lightsail.model.ExportSnapshotRecordSourceInfo.wrap(buildAwsValue())
}
object ExportSnapshotRecordSourceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ExportSnapshotRecordSourceInfo =
      zio.aws.lightsail.model.ExportSnapshotRecordSourceInfo(
        resourceType.map(value => value),
        createdAt.map(value => value),
        name.map(value => value),
        arn.map(value => value),
        fromResourceName.map(value => value),
        fromResourceArn.map(value => value),
        instanceSnapshotInfo.map(value => value.asEditable),
        diskSnapshotInfo.map(value => value.asEditable)
      )
    def resourceType
        : Option[zio.aws.lightsail.model.ExportSnapshotRecordSourceType]
    def createdAt: Option[IsoDate]
    def name: Option[NonEmptyString]
    def arn: Option[NonEmptyString]
    def fromResourceName: Option[NonEmptyString]
    def fromResourceArn: Option[NonEmptyString]
    def instanceSnapshotInfo
        : Option[zio.aws.lightsail.model.InstanceSnapshotInfo.ReadOnly]
    def diskSnapshotInfo
        : Option[zio.aws.lightsail.model.DiskSnapshotInfo.ReadOnly]
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ExportSnapshotRecordSourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getFromResourceName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromResourceName", fromResourceName)
    def getFromResourceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromResourceArn", fromResourceArn)
    def getInstanceSnapshotInfo: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.InstanceSnapshotInfo.ReadOnly
    ] = AwsError.unwrapOptionField("instanceSnapshotInfo", instanceSnapshotInfo)
    def getDiskSnapshotInfo: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.DiskSnapshotInfo.ReadOnly
    ] = AwsError.unwrapOptionField("diskSnapshotInfo", diskSnapshotInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo
  ) extends zio.aws.lightsail.model.ExportSnapshotRecordSourceInfo.ReadOnly {
    override val resourceType
        : Option[zio.aws.lightsail.model.ExportSnapshotRecordSourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.lightsail.model.ExportSnapshotRecordSourceType.wrap(value)
      )
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val fromResourceName: Option[NonEmptyString] = scala
      .Option(impl.fromResourceName())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val fromResourceArn: Option[NonEmptyString] = scala
      .Option(impl.fromResourceArn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val instanceSnapshotInfo
        : Option[zio.aws.lightsail.model.InstanceSnapshotInfo.ReadOnly] = scala
      .Option(impl.instanceSnapshotInfo())
      .map(value => zio.aws.lightsail.model.InstanceSnapshotInfo.wrap(value))
    override val diskSnapshotInfo
        : Option[zio.aws.lightsail.model.DiskSnapshotInfo.ReadOnly] = scala
      .Option(impl.diskSnapshotInfo())
      .map(value => zio.aws.lightsail.model.DiskSnapshotInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo
  ): zio.aws.lightsail.model.ExportSnapshotRecordSourceInfo.ReadOnly =
    new Wrapper(impl)
}
