package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAlarmsRequest(
    alarmName: Option[ResourceName] = None,
    pageToken: Option[String] = None,
    monitoredResourceName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest = {
    import GetAlarmsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest
      .builder()
      .optionallyWith(
        alarmName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.alarmName)
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .optionallyWith(
        monitoredResourceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.monitoredResourceName)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetAlarmsRequest.ReadOnly =
    zio.aws.lightsail.model.GetAlarmsRequest.wrap(buildAwsValue())
}
object GetAlarmsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetAlarmsRequest =
      zio.aws.lightsail.model.GetAlarmsRequest(
        alarmName.map(value => value),
        pageToken.map(value => value),
        monitoredResourceName.map(value => value)
      )
    def alarmName: Option[ResourceName]
    def pageToken: Option[String]
    def monitoredResourceName: Option[ResourceName]
    def getAlarmName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("alarmName", alarmName)
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getMonitoredResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("monitoredResourceName", monitoredResourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest
  ) extends zio.aws.lightsail.model.GetAlarmsRequest.ReadOnly {
    override val alarmName: Option[ResourceName] = scala
      .Option(impl.alarmName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val pageToken: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
    override val monitoredResourceName: Option[ResourceName] = scala
      .Option(impl.monitoredResourceName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest
  ): zio.aws.lightsail.model.GetAlarmsRequest.ReadOnly = new Wrapper(impl)
}
