package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  CertificateName,
  IncludeCertificateDetails
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetCertificatesRequest(
    certificateStatuses: Option[
      Iterable[zio.aws.lightsail.model.CertificateStatus]
    ] = None,
    includeCertificateDetails: Option[IncludeCertificateDetails] = None,
    certificateName: Option[CertificateName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest = {
    import GetCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest
      .builder()
      .optionallyWith(
        certificateStatuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.certificateStatusesWithStrings)
      .optionallyWith(
        includeCertificateDetails.map(value =>
          IncludeCertificateDetails.unwrap(value): java.lang.Boolean
        )
      )(_.includeCertificateDetails)
      .optionallyWith(
        certificateName.map(value =>
          CertificateName.unwrap(value): java.lang.String
        )
      )(_.certificateName)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetCertificatesRequest.ReadOnly =
    zio.aws.lightsail.model.GetCertificatesRequest.wrap(buildAwsValue())
}
object GetCertificatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetCertificatesRequest =
      zio.aws.lightsail.model.GetCertificatesRequest(
        certificateStatuses.map(value => value),
        includeCertificateDetails.map(value => value),
        certificateName.map(value => value)
      )
    def certificateStatuses
        : Option[List[zio.aws.lightsail.model.CertificateStatus]]
    def includeCertificateDetails: Option[IncludeCertificateDetails]
    def certificateName: Option[CertificateName]
    def getCertificateStatuses
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.CertificateStatus]] =
      AwsError.unwrapOptionField("certificateStatuses", certificateStatuses)
    def getIncludeCertificateDetails
        : ZIO[Any, AwsError, IncludeCertificateDetails] = AwsError
      .unwrapOptionField("includeCertificateDetails", includeCertificateDetails)
    def getCertificateName: ZIO[Any, AwsError, CertificateName] =
      AwsError.unwrapOptionField("certificateName", certificateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest
  ) extends zio.aws.lightsail.model.GetCertificatesRequest.ReadOnly {
    override val certificateStatuses
        : Option[List[zio.aws.lightsail.model.CertificateStatus]] = scala
      .Option(impl.certificateStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.CertificateStatus.wrap(item)
        }.toList
      )
    override val includeCertificateDetails: Option[IncludeCertificateDetails] =
      scala
        .Option(impl.includeCertificateDetails())
        .map(value =>
          zio.aws.lightsail.model.primitives.IncludeCertificateDetails(value)
        )
    override val certificateName: Option[CertificateName] = scala
      .Option(impl.certificateName())
      .map(value => zio.aws.lightsail.model.primitives.CertificateName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest
  ): zio.aws.lightsail.model.GetCertificatesRequest.ReadOnly = new Wrapper(impl)
}
