package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ContainerServiceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetContainerServicesRequest(
    serviceName: Option[ContainerServiceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest = {
    import GetContainerServicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest
      .builder()
      .optionallyWith(
        serviceName.map(value =>
          ContainerServiceName.unwrap(value): java.lang.String
        )
      )(_.serviceName)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetContainerServicesRequest.ReadOnly =
    zio.aws.lightsail.model.GetContainerServicesRequest.wrap(buildAwsValue())
}
object GetContainerServicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetContainerServicesRequest =
      zio.aws.lightsail.model
        .GetContainerServicesRequest(serviceName.map(value => value))
    def serviceName: Option[ContainerServiceName]
    def getServiceName: ZIO[Any, AwsError, ContainerServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest
  ) extends zio.aws.lightsail.model.GetContainerServicesRequest.ReadOnly {
    override val serviceName: Option[ContainerServiceName] = scala
      .Option(impl.serviceName())
      .map(value =>
        zio.aws.lightsail.model.primitives.ContainerServiceName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest
  ): zio.aws.lightsail.model.GetContainerServicesRequest.ReadOnly = new Wrapper(
    impl
  )
}
