package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDiskResponse(
    disk: Option[zio.aws.lightsail.model.Disk] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDiskResponse = {
    import GetDiskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskResponse
      .builder()
      .optionallyWith(disk.map(value => value.buildAwsValue()))(_.disk)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetDiskResponse.ReadOnly =
    zio.aws.lightsail.model.GetDiskResponse.wrap(buildAwsValue())
}
object GetDiskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDiskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDiskResponse =
      zio.aws.lightsail.model
        .GetDiskResponse(disk.map(value => value.asEditable))
    def disk: Option[zio.aws.lightsail.model.Disk.ReadOnly]
    def getDisk: ZIO[Any, AwsError, zio.aws.lightsail.model.Disk.ReadOnly] =
      AwsError.unwrapOptionField("disk", disk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskResponse
  ) extends zio.aws.lightsail.model.GetDiskResponse.ReadOnly {
    override val disk: Option[zio.aws.lightsail.model.Disk.ReadOnly] = scala
      .Option(impl.disk())
      .map(value => zio.aws.lightsail.model.Disk.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskResponse
  ): zio.aws.lightsail.model.GetDiskResponse.ReadOnly = new Wrapper(impl)
}
