package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDistributionMetricDataResponse(
    metricName: Option[zio.aws.lightsail.model.DistributionMetricName] = None,
    metricData: Option[Iterable[zio.aws.lightsail.model.MetricDatapoint]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataResponse = {
    import GetDistributionMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataResponse
      .builder()
      .optionallyWith(metricName.map(value => value.unwrap))(_.metricName)
      .optionallyWith(
        metricData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricData)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetDistributionMetricDataResponse.ReadOnly =
    zio.aws.lightsail.model.GetDistributionMetricDataResponse
      .wrap(buildAwsValue())
}
object GetDistributionMetricDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDistributionMetricDataResponse =
      zio.aws.lightsail.model.GetDistributionMetricDataResponse(
        metricName.map(value => value),
        metricData.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metricName: Option[zio.aws.lightsail.model.DistributionMetricName]
    def metricData
        : Option[List[zio.aws.lightsail.model.MetricDatapoint.ReadOnly]]
    def getMetricName
        : ZIO[Any, AwsError, zio.aws.lightsail.model.DistributionMetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMetricData: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.MetricDatapoint.ReadOnly
    ]] = AwsError.unwrapOptionField("metricData", metricData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataResponse
  ) extends zio.aws.lightsail.model.GetDistributionMetricDataResponse.ReadOnly {
    override val metricName
        : Option[zio.aws.lightsail.model.DistributionMetricName] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.lightsail.model.DistributionMetricName.wrap(value))
    override val metricData
        : Option[List[zio.aws.lightsail.model.MetricDatapoint.ReadOnly]] = scala
      .Option(impl.metricData())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.MetricDatapoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataResponse
  ): zio.aws.lightsail.model.GetDistributionMetricDataResponse.ReadOnly =
    new Wrapper(impl)
}
