package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDomainResponse(
    domain: Option[zio.aws.lightsail.model.Domain] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDomainResponse = {
    import GetDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDomainResponse
      .builder()
      .optionallyWith(domain.map(value => value.buildAwsValue()))(_.domain)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetDomainResponse.ReadOnly =
    zio.aws.lightsail.model.GetDomainResponse.wrap(buildAwsValue())
}
object GetDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDomainResponse =
      zio.aws.lightsail.model
        .GetDomainResponse(domain.map(value => value.asEditable))
    def domain: Option[zio.aws.lightsail.model.Domain.ReadOnly]
    def getDomain: ZIO[Any, AwsError, zio.aws.lightsail.model.Domain.ReadOnly] =
      AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDomainResponse
  ) extends zio.aws.lightsail.model.GetDomainResponse.ReadOnly {
    override val domain: Option[zio.aws.lightsail.model.Domain.ReadOnly] = scala
      .Option(impl.domain())
      .map(value => zio.aws.lightsail.model.Domain.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDomainResponse
  ): zio.aws.lightsail.model.GetDomainResponse.ReadOnly = new Wrapper(impl)
}
