package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetExportSnapshotRecordsRequest(
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest = {
    import GetExportSnapshotRecordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetExportSnapshotRecordsRequest.ReadOnly =
    zio.aws.lightsail.model.GetExportSnapshotRecordsRequest
      .wrap(buildAwsValue())
}
object GetExportSnapshotRecordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetExportSnapshotRecordsRequest =
      zio.aws.lightsail.model
        .GetExportSnapshotRecordsRequest(pageToken.map(value => value))
    def pageToken: Option[String]
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest
  ) extends zio.aws.lightsail.model.GetExportSnapshotRecordsRequest.ReadOnly {
    override val pageToken: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest
  ): zio.aws.lightsail.model.GetExportSnapshotRecordsRequest.ReadOnly =
    new Wrapper(impl)
}
