package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetExportSnapshotRecordsResponse(
    exportSnapshotRecords: Option[
      Iterable[zio.aws.lightsail.model.ExportSnapshotRecord]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse = {
    import GetExportSnapshotRecordsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse
      .builder()
      .optionallyWith(
        exportSnapshotRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.exportSnapshotRecords)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly =
    zio.aws.lightsail.model.GetExportSnapshotRecordsResponse
      .wrap(buildAwsValue())
}
object GetExportSnapshotRecordsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetExportSnapshotRecordsResponse =
      zio.aws.lightsail.model.GetExportSnapshotRecordsResponse(
        exportSnapshotRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def exportSnapshotRecords
        : Option[List[zio.aws.lightsail.model.ExportSnapshotRecord.ReadOnly]]
    def nextPageToken: Option[String]
    def getExportSnapshotRecords: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.ExportSnapshotRecord.ReadOnly
    ]] =
      AwsError.unwrapOptionField("exportSnapshotRecords", exportSnapshotRecords)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse
  ) extends zio.aws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly {
    override val exportSnapshotRecords
        : Option[List[zio.aws.lightsail.model.ExportSnapshotRecord.ReadOnly]] =
      scala
        .Option(impl.exportSnapshotRecords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.ExportSnapshotRecord.wrap(item)
          }.toList
        )
    override val nextPageToken: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse
  ): zio.aws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly =
    new Wrapper(impl)
}
