package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetInstanceAccessDetailsRequest(
    instanceName: ResourceName,
    protocol: Option[zio.aws.lightsail.model.InstanceAccessProtocol] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest = {
    import GetInstanceAccessDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest
      .builder()
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetInstanceAccessDetailsRequest.ReadOnly =
    zio.aws.lightsail.model.GetInstanceAccessDetailsRequest
      .wrap(buildAwsValue())
}
object GetInstanceAccessDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstanceAccessDetailsRequest =
      zio.aws.lightsail.model.GetInstanceAccessDetailsRequest(
        instanceName,
        protocol.map(value => value)
      )
    def instanceName: ResourceName
    def protocol: Option[zio.aws.lightsail.model.InstanceAccessProtocol]
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.lightsail.model.InstanceAccessProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest
  ) extends zio.aws.lightsail.model.GetInstanceAccessDetailsRequest.ReadOnly {
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
    override val protocol
        : Option[zio.aws.lightsail.model.InstanceAccessProtocol] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.lightsail.model.InstanceAccessProtocol.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest
  ): zio.aws.lightsail.model.GetInstanceAccessDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
