package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetInstancePortStatesResponse(
    portStates: Option[Iterable[zio.aws.lightsail.model.InstancePortState]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse = {
    import GetInstancePortStatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse
      .builder()
      .optionallyWith(
        portStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portStates)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetInstancePortStatesResponse.ReadOnly =
    zio.aws.lightsail.model.GetInstancePortStatesResponse.wrap(buildAwsValue())
}
object GetInstancePortStatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstancePortStatesResponse =
      zio.aws.lightsail.model.GetInstancePortStatesResponse(
        portStates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def portStates
        : Option[List[zio.aws.lightsail.model.InstancePortState.ReadOnly]]
    def getPortStates: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.InstancePortState.ReadOnly
    ]] = AwsError.unwrapOptionField("portStates", portStates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse
  ) extends zio.aws.lightsail.model.GetInstancePortStatesResponse.ReadOnly {
    override val portStates
        : Option[List[zio.aws.lightsail.model.InstancePortState.ReadOnly]] =
      scala
        .Option(impl.portStates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.InstancePortState.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse
  ): zio.aws.lightsail.model.GetInstancePortStatesResponse.ReadOnly =
    new Wrapper(impl)
}
