package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetInstancesRequest(pageToken: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstancesRequest = {
    import GetInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstancesRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetInstancesRequest.ReadOnly =
    zio.aws.lightsail.model.GetInstancesRequest.wrap(buildAwsValue())
}
object GetInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstancesRequest =
      zio.aws.lightsail.model.GetInstancesRequest(pageToken.map(value => value))
    def pageToken: Option[String]
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancesRequest
  ) extends zio.aws.lightsail.model.GetInstancesRequest.ReadOnly {
    override val pageToken: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancesRequest
  ): zio.aws.lightsail.model.GetInstancesRequest.ReadOnly = new Wrapper(impl)
}
