package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetKeyPairRequest(keyPairName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest = {
    import GetKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest
      .builder()
      .keyPairName(ResourceName.unwrap(keyPairName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetKeyPairRequest.ReadOnly =
    zio.aws.lightsail.model.GetKeyPairRequest.wrap(buildAwsValue())
}
object GetKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetKeyPairRequest =
      zio.aws.lightsail.model.GetKeyPairRequest(keyPairName)
    def keyPairName: ResourceName
    def getKeyPairName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(keyPairName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest
  ) extends zio.aws.lightsail.model.GetKeyPairRequest.ReadOnly {
    override val keyPairName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.keyPairName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest
  ): zio.aws.lightsail.model.GetKeyPairRequest.ReadOnly = new Wrapper(impl)
}
