package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetKeyPairsResponse(
    keyPairs: Option[Iterable[zio.aws.lightsail.model.KeyPair]] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse = {
    import GetKeyPairsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse
      .builder()
      .optionallyWith(
        keyPairs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keyPairs)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetKeyPairsResponse.ReadOnly =
    zio.aws.lightsail.model.GetKeyPairsResponse.wrap(buildAwsValue())
}
object GetKeyPairsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetKeyPairsResponse =
      zio.aws.lightsail.model.GetKeyPairsResponse(
        keyPairs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def keyPairs: Option[List[zio.aws.lightsail.model.KeyPair.ReadOnly]]
    def nextPageToken: Option[String]
    def getKeyPairs
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.KeyPair.ReadOnly]] =
      AwsError.unwrapOptionField("keyPairs", keyPairs)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse
  ) extends zio.aws.lightsail.model.GetKeyPairsResponse.ReadOnly {
    override val keyPairs
        : Option[List[zio.aws.lightsail.model.KeyPair.ReadOnly]] = scala
      .Option(impl.keyPairs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.KeyPair.wrap(item)
        }.toList
      )
    override val nextPageToken: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse
  ): zio.aws.lightsail.model.GetKeyPairsResponse.ReadOnly = new Wrapper(impl)
}
