package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetLoadBalancersResponse(
    loadBalancers: Option[Iterable[zio.aws.lightsail.model.LoadBalancer]] =
      None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse = {
    import GetLoadBalancersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse
      .builder()
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetLoadBalancersResponse.ReadOnly =
    zio.aws.lightsail.model.GetLoadBalancersResponse.wrap(buildAwsValue())
}
object GetLoadBalancersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetLoadBalancersResponse =
      zio.aws.lightsail.model.GetLoadBalancersResponse(
        loadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def loadBalancers
        : Option[List[zio.aws.lightsail.model.LoadBalancer.ReadOnly]]
    def nextPageToken: Option[String]
    def getLoadBalancers: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.LoadBalancer.ReadOnly
    ]] = AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse
  ) extends zio.aws.lightsail.model.GetLoadBalancersResponse.ReadOnly {
    override val loadBalancers
        : Option[List[zio.aws.lightsail.model.LoadBalancer.ReadOnly]] = scala
      .Option(impl.loadBalancers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.LoadBalancer.wrap(item)
        }.toList
      )
    override val nextPageToken: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse
  ): zio.aws.lightsail.model.GetLoadBalancersResponse.ReadOnly = new Wrapper(
    impl
  )
}
