package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetOperationsResponse(
    operations: Option[Iterable[zio.aws.lightsail.model.Operation]] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetOperationsResponse = {
    import GetOperationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetOperationsResponse
      .builder()
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetOperationsResponse.ReadOnly =
    zio.aws.lightsail.model.GetOperationsResponse.wrap(buildAwsValue())
}
object GetOperationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetOperationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetOperationsResponse =
      zio.aws.lightsail.model.GetOperationsResponse(
        operations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def operations: Option[List[zio.aws.lightsail.model.Operation.ReadOnly]]
    def nextPageToken: Option[String]
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      AwsError.unwrapOptionField("operations", operations)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationsResponse
  ) extends zio.aws.lightsail.model.GetOperationsResponse.ReadOnly {
    override val operations
        : Option[List[zio.aws.lightsail.model.Operation.ReadOnly]] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.Operation.wrap(item)
        }.toList
      )
    override val nextPageToken: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationsResponse
  ): zio.aws.lightsail.model.GetOperationsResponse.ReadOnly = new Wrapper(impl)
}
