package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRelationalDatabaseBundlesResponse(
    bundles: Option[
      Iterable[zio.aws.lightsail.model.RelationalDatabaseBundle]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse = {
    import GetRelationalDatabaseBundlesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse
      .builder()
      .optionallyWith(
        bundles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bundles)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseBundlesResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseBundlesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseBundlesResponse =
      zio.aws.lightsail.model.GetRelationalDatabaseBundlesResponse(
        bundles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def bundles: Option[
      List[zio.aws.lightsail.model.RelationalDatabaseBundle.ReadOnly]
    ]
    def nextPageToken: Option[String]
    def getBundles: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.RelationalDatabaseBundle.ReadOnly
    ]] = AwsError.unwrapOptionField("bundles", bundles)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly {
    override val bundles: Option[
      List[zio.aws.lightsail.model.RelationalDatabaseBundle.ReadOnly]
    ] = scala
      .Option(impl.bundles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.RelationalDatabaseBundle.wrap(item)
        }.toList
      )
    override val nextPageToken: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse
  ): zio.aws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly =
    new Wrapper(impl)
}
