package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{IsoDate, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetRelationalDatabaseLogEventsRequest(
    relationalDatabaseName: ResourceName,
    logStreamName: String,
    startTime: Option[IsoDate] = None,
    endTime: Option[IsoDate] = None,
    startFromHead: Option[Boolean] = None,
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest = {
    import GetRelationalDatabaseLogEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .logStreamName(logStreamName: java.lang.String)
      .optionallyWith(startTime.map(value => IsoDate.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => IsoDate.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(startFromHead.map(value => value: java.lang.Boolean))(
        _.startFromHead
      )
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseLogEventsRequest.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseLogEventsRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseLogEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseLogEventsRequest =
      zio.aws.lightsail.model.GetRelationalDatabaseLogEventsRequest(
        relationalDatabaseName,
        logStreamName,
        startTime.map(value => value),
        endTime.map(value => value),
        startFromHead.map(value => value),
        pageToken.map(value => value)
      )
    def relationalDatabaseName: ResourceName
    def logStreamName: String
    def startTime: Option[IsoDate]
    def endTime: Option[IsoDate]
    def startFromHead: Option[Boolean]
    def pageToken: Option[String]
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
    def getLogStreamName: ZIO[Any, Nothing, String] = ZIO.succeed(logStreamName)
    def getStartTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStartFromHead: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("startFromHead", startFromHead)
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseLogEventsRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
    override val logStreamName: String = impl.logStreamName(): String
    override val startTime: Option[IsoDate] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val endTime: Option[IsoDate] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val startFromHead: Option[Boolean] =
      scala.Option(impl.startFromHead()).map(value => value: Boolean)
    override val pageToken: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest
  ): zio.aws.lightsail.model.GetRelationalDatabaseLogEventsRequest.ReadOnly =
    new Wrapper(impl)
}
