package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRelationalDatabaseMasterUserPasswordRequest(
    relationalDatabaseName: ResourceName,
    passwordVersion: Option[
      zio.aws.lightsail.model.RelationalDatabasePasswordVersion
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest = {
    import GetRelationalDatabaseMasterUserPasswordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .optionallyWith(passwordVersion.map(value => value.unwrap))(
        _.passwordVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseMasterUserPasswordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest =
      zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest(
        relationalDatabaseName,
        passwordVersion.map(value => value)
      )
    def relationalDatabaseName: ResourceName
    def passwordVersion
        : Option[zio.aws.lightsail.model.RelationalDatabasePasswordVersion]
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
    def getPasswordVersion: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.RelationalDatabasePasswordVersion
    ] = AwsError.unwrapOptionField("passwordVersion", passwordVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
    override val passwordVersion
        : Option[zio.aws.lightsail.model.RelationalDatabasePasswordVersion] =
      scala
        .Option(impl.passwordVersion())
        .map(value =>
          zio.aws.lightsail.model.RelationalDatabasePasswordVersion.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest
  ): zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest.ReadOnly =
    new Wrapper(impl)
}
