package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRelationalDatabaseParametersRequest(
    relationalDatabaseName: ResourceName,
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest = {
    import GetRelationalDatabaseParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseParametersRequest.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseParametersRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseParametersRequest =
      zio.aws.lightsail.model.GetRelationalDatabaseParametersRequest(
        relationalDatabaseName,
        pageToken.map(value => value)
      )
    def relationalDatabaseName: ResourceName
    def pageToken: Option[String]
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseParametersRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
    override val pageToken: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest
  ): zio.aws.lightsail.model.GetRelationalDatabaseParametersRequest.ReadOnly =
    new Wrapper(impl)
}
