package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRelationalDatabaseResponse(
    relationalDatabase: Option[zio.aws.lightsail.model.RelationalDatabase] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse = {
    import GetRelationalDatabaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse
      .builder()
      .optionallyWith(relationalDatabase.map(value => value.buildAwsValue()))(
        _.relationalDatabase
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseResponse.wrap(buildAwsValue())
}
object GetRelationalDatabaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetRelationalDatabaseResponse =
      zio.aws.lightsail.model.GetRelationalDatabaseResponse(
        relationalDatabase.map(value => value.asEditable)
      )
    def relationalDatabase
        : Option[zio.aws.lightsail.model.RelationalDatabase.ReadOnly]
    def getRelationalDatabase: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.RelationalDatabase.ReadOnly
    ] = AwsError.unwrapOptionField("relationalDatabase", relationalDatabase)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly {
    override val relationalDatabase
        : Option[zio.aws.lightsail.model.RelationalDatabase.ReadOnly] = scala
      .Option(impl.relationalDatabase())
      .map(value => zio.aws.lightsail.model.RelationalDatabase.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse
  ): zio.aws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly =
    new Wrapper(impl)
}
