package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportKeyPairResponse(
    operation: Option[zio.aws.lightsail.model.Operation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse = {
    import ImportKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ImportKeyPairResponse.ReadOnly =
    zio.aws.lightsail.model.ImportKeyPairResponse.wrap(buildAwsValue())
}
object ImportKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ImportKeyPairResponse =
      zio.aws.lightsail.model
        .ImportKeyPairResponse(operation.map(value => value.asEditable))
    def operation: Option[zio.aws.lightsail.model.Operation.ReadOnly]
    def getOperation
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse
  ) extends zio.aws.lightsail.model.ImportKeyPairResponse.ReadOnly {
    override val operation: Option[zio.aws.lightsail.model.Operation.ReadOnly] =
      scala
        .Option(impl.operation())
        .map(value => zio.aws.lightsail.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse
  ): zio.aws.lightsail.model.ImportKeyPairResponse.ReadOnly = new Wrapper(impl)
}
