package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InputOrigin(
    name: Option[ResourceName] = None,
    regionName: Option[zio.aws.lightsail.model.RegionName] = None,
    protocolPolicy: Option[zio.aws.lightsail.model.OriginProtocolPolicyEnum] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InputOrigin = {
    import InputOrigin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InputOrigin
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(regionName.map(value => value.unwrap))(_.regionName)
      .optionallyWith(protocolPolicy.map(value => value.unwrap))(
        _.protocolPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InputOrigin.ReadOnly =
    zio.aws.lightsail.model.InputOrigin.wrap(buildAwsValue())
}
object InputOrigin {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InputOrigin
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InputOrigin =
      zio.aws.lightsail.model.InputOrigin(
        name.map(value => value),
        regionName.map(value => value),
        protocolPolicy.map(value => value)
      )
    def name: Option[ResourceName]
    def regionName: Option[zio.aws.lightsail.model.RegionName]
    def protocolPolicy: Option[zio.aws.lightsail.model.OriginProtocolPolicyEnum]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getRegionName: ZIO[Any, AwsError, zio.aws.lightsail.model.RegionName] =
      AwsError.unwrapOptionField("regionName", regionName)
    def getProtocolPolicy
        : ZIO[Any, AwsError, zio.aws.lightsail.model.OriginProtocolPolicyEnum] =
      AwsError.unwrapOptionField("protocolPolicy", protocolPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InputOrigin
  ) extends zio.aws.lightsail.model.InputOrigin.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val regionName: Option[zio.aws.lightsail.model.RegionName] = scala
      .Option(impl.regionName())
      .map(value => zio.aws.lightsail.model.RegionName.wrap(value))
    override val protocolPolicy
        : Option[zio.aws.lightsail.model.OriginProtocolPolicyEnum] = scala
      .Option(impl.protocolPolicy())
      .map(value =>
        zio.aws.lightsail.model.OriginProtocolPolicyEnum.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InputOrigin
  ): zio.aws.lightsail.model.InputOrigin.ReadOnly = new Wrapper(impl)
}
