package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{NonEmptyString, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceEntry(
    sourceName: ResourceName,
    instanceType: NonEmptyString,
    portInfoSource: zio.aws.lightsail.model.PortInfoSourceType,
    userData: Option[String] = None,
    availabilityZone: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceEntry = {
    import InstanceEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceEntry
      .builder()
      .sourceName(ResourceName.unwrap(sourceName): java.lang.String)
      .instanceType(NonEmptyString.unwrap(instanceType): java.lang.String)
      .portInfoSource(portInfoSource.unwrap)
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .availabilityZone(availabilityZone: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InstanceEntry.ReadOnly =
    zio.aws.lightsail.model.InstanceEntry.wrap(buildAwsValue())
}
object InstanceEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InstanceEntry =
      zio.aws.lightsail.model.InstanceEntry(
        sourceName,
        instanceType,
        portInfoSource,
        userData.map(value => value),
        availabilityZone
      )
    def sourceName: ResourceName
    def instanceType: NonEmptyString
    def portInfoSource: zio.aws.lightsail.model.PortInfoSourceType
    def userData: Option[String]
    def availabilityZone: String
    def getSourceName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(sourceName)
    def getInstanceType: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(instanceType)
    def getPortInfoSource
        : ZIO[Any, Nothing, zio.aws.lightsail.model.PortInfoSourceType] =
      ZIO.succeed(portInfoSource)
    def getUserData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userData)
    def getAvailabilityZone: ZIO[Any, Nothing, String] =
      ZIO.succeed(availabilityZone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceEntry
  ) extends zio.aws.lightsail.model.InstanceEntry.ReadOnly {
    override val sourceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.sourceName())
    override val instanceType: NonEmptyString =
      zio.aws.lightsail.model.primitives.NonEmptyString(impl.instanceType())
    override val portInfoSource: zio.aws.lightsail.model.PortInfoSourceType =
      zio.aws.lightsail.model.PortInfoSourceType.wrap(impl.portInfoSource())
    override val userData: Option[String] =
      scala.Option(impl.userData()).map(value => value: String)
    override val availabilityZone: String = impl.availabilityZone(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceEntry
  ): zio.aws.lightsail.model.InstanceEntry.ReadOnly = new Wrapper(impl)
}
