package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceHardware(
    cpuCount: Option[Integer] = None,
    disks: Option[Iterable[zio.aws.lightsail.model.Disk]] = None,
    ramSizeInGb: Option[Float] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceHardware = {
    import InstanceHardware.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceHardware
      .builder()
      .optionallyWith(
        cpuCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.cpuCount)
      .optionallyWith(
        disks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.disks)
      .optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(
        _.ramSizeInGb
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InstanceHardware.ReadOnly =
    zio.aws.lightsail.model.InstanceHardware.wrap(buildAwsValue())
}
object InstanceHardware {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceHardware
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InstanceHardware =
      zio.aws.lightsail.model.InstanceHardware(
        cpuCount.map(value => value),
        disks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ramSizeInGb.map(value => value)
      )
    def cpuCount: Option[Integer]
    def disks: Option[List[zio.aws.lightsail.model.Disk.ReadOnly]]
    def ramSizeInGb: Option[Float]
    def getCpuCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cpuCount", cpuCount)
    def getDisks
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Disk.ReadOnly]] =
      AwsError.unwrapOptionField("disks", disks)
    def getRamSizeInGb: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGb)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceHardware
  ) extends zio.aws.lightsail.model.InstanceHardware.ReadOnly {
    override val cpuCount: Option[Integer] = scala
      .Option(impl.cpuCount())
      .map(value => zio.aws.lightsail.model.primitives.Integer(value))
    override val disks: Option[List[zio.aws.lightsail.model.Disk.ReadOnly]] =
      scala
        .Option(impl.disks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Disk.wrap(item)
          }.toList
        )
    override val ramSizeInGb: Option[Float] =
      scala.Option(impl.ramSizeInGb()).map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceHardware
  ): zio.aws.lightsail.model.InstanceHardware.ReadOnly = new Wrapper(impl)
}
