package zio.aws.lightsail.model
import java.lang.Integer
import zio.aws.lightsail.model.primitives.Port
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstancePortState(
    fromPort: Option[Port] = None,
    toPort: Option[Port] = None,
    protocol: Option[zio.aws.lightsail.model.NetworkProtocol] = None,
    state: Option[zio.aws.lightsail.model.PortState] = None,
    cidrs: Option[Iterable[String]] = None,
    ipv6Cidrs: Option[Iterable[String]] = None,
    cidrListAliases: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstancePortState = {
    import InstancePortState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstancePortState
      .builder()
      .optionallyWith(fromPort.map(value => Port.unwrap(value): Integer))(
        _.fromPort
      )
      .optionallyWith(toPort.map(value => Port.unwrap(value): Integer))(
        _.toPort
      )
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        cidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cidrs)
      .optionallyWith(
        ipv6Cidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipv6Cidrs)
      .optionallyWith(
        cidrListAliases.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cidrListAliases)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InstancePortState.ReadOnly =
    zio.aws.lightsail.model.InstancePortState.wrap(buildAwsValue())
}
object InstancePortState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstancePortState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InstancePortState =
      zio.aws.lightsail.model.InstancePortState(
        fromPort.map(value => value),
        toPort.map(value => value),
        protocol.map(value => value),
        state.map(value => value),
        cidrs.map(value => value),
        ipv6Cidrs.map(value => value),
        cidrListAliases.map(value => value)
      )
    def fromPort: Option[Port]
    def toPort: Option[Port]
    def protocol: Option[zio.aws.lightsail.model.NetworkProtocol]
    def state: Option[zio.aws.lightsail.model.PortState]
    def cidrs: Option[List[String]]
    def ipv6Cidrs: Option[List[String]]
    def cidrListAliases: Option[List[String]]
    def getFromPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.lightsail.model.NetworkProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getState: ZIO[Any, AwsError, zio.aws.lightsail.model.PortState] =
      AwsError.unwrapOptionField("state", state)
    def getCidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cidrs", cidrs)
    def getIpv6Cidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ipv6Cidrs", ipv6Cidrs)
    def getCidrListAliases: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cidrListAliases", cidrListAliases)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstancePortState
  ) extends zio.aws.lightsail.model.InstancePortState.ReadOnly {
    override val fromPort: Option[Port] = scala
      .Option(impl.fromPort())
      .map(value => zio.aws.lightsail.model.primitives.Port(value))
    override val toPort: Option[Port] = scala
      .Option(impl.toPort())
      .map(value => zio.aws.lightsail.model.primitives.Port(value))
    override val protocol: Option[zio.aws.lightsail.model.NetworkProtocol] =
      scala
        .Option(impl.protocol())
        .map(value => zio.aws.lightsail.model.NetworkProtocol.wrap(value))
    override val state: Option[zio.aws.lightsail.model.PortState] = scala
      .Option(impl.state())
      .map(value => zio.aws.lightsail.model.PortState.wrap(value))
    override val cidrs: Option[List[String]] = scala
      .Option(impl.cidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val ipv6Cidrs: Option[List[String]] = scala
      .Option(impl.ipv6Cidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val cidrListAliases: Option[List[String]] = scala
      .Option(impl.cidrListAliases())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstancePortState
  ): zio.aws.lightsail.model.InstancePortState.ReadOnly = new Wrapper(impl)
}
