package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceState(
    code: Option[Integer] = None,
    name: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceState = {
    import InstanceState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceState
      .builder()
      .optionallyWith(
        code.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.code)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InstanceState.ReadOnly =
    zio.aws.lightsail.model.InstanceState.wrap(buildAwsValue())
}
object InstanceState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InstanceState =
      zio.aws.lightsail.model
        .InstanceState(code.map(value => value), name.map(value => value))
    def code: Option[Integer]
    def name: Option[String]
    def getCode: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("code", code)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceState
  ) extends zio.aws.lightsail.model.InstanceState.ReadOnly {
    override val code: Option[Integer] = scala
      .Option(impl.code())
      .map(value => zio.aws.lightsail.model.primitives.Integer(value))
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceState
  ): zio.aws.lightsail.model.InstanceState.ReadOnly = new Wrapper(impl)
}
