package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  Port,
  Integer,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class LoadBalancer(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[zio.aws.lightsail.model.ResourceLocation] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None,
    dnsName: Option[NonEmptyString] = None,
    state: Option[zio.aws.lightsail.model.LoadBalancerState] = None,
    protocol: Option[zio.aws.lightsail.model.LoadBalancerProtocol] = None,
    publicPorts: Option[Iterable[Port]] = None,
    healthCheckPath: Option[NonEmptyString] = None,
    instancePort: Option[Integer] = None,
    instanceHealthSummary: Option[
      Iterable[zio.aws.lightsail.model.InstanceHealthSummary]
    ] = None,
    tlsCertificateSummaries: Option[
      Iterable[zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary]
    ] = None,
    configurationOptions: Option[
      Map[zio.aws.lightsail.model.LoadBalancerAttributeName, String]
    ] = None,
    ipAddressType: Option[zio.aws.lightsail.model.IpAddressType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancer = {
    import LoadBalancer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancer
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        dnsName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        publicPorts.map(value =>
          value.map { item =>
            Port.unwrap(item): java.lang.Integer
          }.asJavaCollection
        )
      )(_.publicPorts)
      .optionallyWith(
        healthCheckPath.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.healthCheckPath)
      .optionallyWith(
        instancePort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.instancePort)
      .optionallyWith(
        instanceHealthSummary.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceHealthSummary)
      .optionallyWith(
        tlsCertificateSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tlsCertificateSummaries)
      .optionallyWith(
        configurationOptions.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.configurationOptionsWithStrings)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.LoadBalancer.ReadOnly =
    zio.aws.lightsail.model.LoadBalancer.wrap(buildAwsValue())
}
object LoadBalancer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.LoadBalancer =
      zio.aws.lightsail.model.LoadBalancer(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dnsName.map(value => value),
        state.map(value => value),
        protocol.map(value => value),
        publicPorts.map(value => value),
        healthCheckPath.map(value => value),
        instancePort.map(value => value),
        instanceHealthSummary.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tlsCertificateSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurationOptions.map(value => value),
        ipAddressType.map(value => value)
      )
    def name: Option[ResourceName]
    def arn: Option[NonEmptyString]
    def supportCode: Option[String]
    def createdAt: Option[IsoDate]
    def location: Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def dnsName: Option[NonEmptyString]
    def state: Option[zio.aws.lightsail.model.LoadBalancerState]
    def protocol: Option[zio.aws.lightsail.model.LoadBalancerProtocol]
    def publicPorts: Option[List[Port]]
    def healthCheckPath: Option[NonEmptyString]
    def instancePort: Option[Integer]
    def instanceHealthSummary
        : Option[List[zio.aws.lightsail.model.InstanceHealthSummary.ReadOnly]]
    def tlsCertificateSummaries: Option[
      List[zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary.ReadOnly]
    ]
    def configurationOptions
        : Option[Map[zio.aws.lightsail.model.LoadBalancerAttributeName, String]]
    def ipAddressType: Option[zio.aws.lightsail.model.IpAddressType]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDnsName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getState
        : ZIO[Any, AwsError, zio.aws.lightsail.model.LoadBalancerState] =
      AwsError.unwrapOptionField("state", state)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.lightsail.model.LoadBalancerProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getPublicPorts: ZIO[Any, AwsError, List[Port]] =
      AwsError.unwrapOptionField("publicPorts", publicPorts)
    def getHealthCheckPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("healthCheckPath", healthCheckPath)
    def getInstancePort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instancePort", instancePort)
    def getInstanceHealthSummary: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.InstanceHealthSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("instanceHealthSummary", instanceHealthSummary)
    def getTlsCertificateSummaries: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "tlsCertificateSummaries",
      tlsCertificateSummaries
    )
    def getConfigurationOptions: ZIO[Any, AwsError, Map[
      zio.aws.lightsail.model.LoadBalancerAttributeName,
      String
    ]] =
      AwsError.unwrapOptionField("configurationOptions", configurationOptions)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancer
  ) extends zio.aws.lightsail.model.LoadBalancer.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val dnsName: Option[NonEmptyString] = scala
      .Option(impl.dnsName())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val state: Option[zio.aws.lightsail.model.LoadBalancerState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.lightsail.model.LoadBalancerState.wrap(value))
    override val protocol
        : Option[zio.aws.lightsail.model.LoadBalancerProtocol] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.lightsail.model.LoadBalancerProtocol.wrap(value))
    override val publicPorts: Option[List[Port]] = scala
      .Option(impl.publicPorts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.primitives.Port(item)
        }.toList
      )
    override val healthCheckPath: Option[NonEmptyString] = scala
      .Option(impl.healthCheckPath())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val instancePort: Option[Integer] = scala
      .Option(impl.instancePort())
      .map(value => zio.aws.lightsail.model.primitives.Integer(value))
    override val instanceHealthSummary
        : Option[List[zio.aws.lightsail.model.InstanceHealthSummary.ReadOnly]] =
      scala
        .Option(impl.instanceHealthSummary())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.InstanceHealthSummary.wrap(item)
          }.toList
        )
    override val tlsCertificateSummaries: Option[
      List[zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary.ReadOnly]
    ] = scala
      .Option(impl.tlsCertificateSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary.wrap(item)
        }.toList
      )
    override val configurationOptions: Option[
      Map[zio.aws.lightsail.model.LoadBalancerAttributeName, String]
    ] = scala
      .Option(impl.configurationOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lightsail.model.LoadBalancerAttributeName
              .wrap(key) -> (value: String)
          })
          .toMap
      )
    override val ipAddressType: Option[zio.aws.lightsail.model.IpAddressType] =
      scala
        .Option(impl.ipAddressType())
        .map(value => zio.aws.lightsail.model.IpAddressType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancer
  ): zio.aws.lightsail.model.LoadBalancer.ReadOnly = new Wrapper(impl)
}
