package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  DomainName,
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class LoadBalancerTlsCertificate(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[zio.aws.lightsail.model.ResourceLocation] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None,
    loadBalancerName: Option[ResourceName] = None,
    isAttached: Option[Boolean] = None,
    status: Option[zio.aws.lightsail.model.LoadBalancerTlsCertificateStatus] =
      None,
    domainName: Option[DomainName] = None,
    domainValidationRecords: Option[Iterable[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
    ]] = None,
    failureReason: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateFailureReason
    ] = None,
    issuedAt: Option[IsoDate] = None,
    issuer: Option[NonEmptyString] = None,
    keyAlgorithm: Option[NonEmptyString] = None,
    notAfter: Option[IsoDate] = None,
    notBefore: Option[IsoDate] = None,
    renewalSummary: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
    ] = None,
    revocationReason: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRevocationReason
    ] = None,
    revokedAt: Option[IsoDate] = None,
    serial: Option[NonEmptyString] = None,
    signatureAlgorithm: Option[NonEmptyString] = None,
    subject: Option[NonEmptyString] = None,
    subjectAlternativeNames: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate = {
    import LoadBalancerTlsCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        loadBalancerName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.loadBalancerName)
      .optionallyWith(isAttached.map(value => value: java.lang.Boolean))(
        _.isAttached
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        domainValidationRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationRecords)
      .optionallyWith(failureReason.map(value => value.unwrap))(_.failureReason)
      .optionallyWith(issuedAt.map(value => IsoDate.unwrap(value): Instant))(
        _.issuedAt
      )
      .optionallyWith(
        issuer.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.issuer)
      .optionallyWith(
        keyAlgorithm.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.keyAlgorithm)
      .optionallyWith(notAfter.map(value => IsoDate.unwrap(value): Instant))(
        _.notAfter
      )
      .optionallyWith(notBefore.map(value => IsoDate.unwrap(value): Instant))(
        _.notBefore
      )
      .optionallyWith(renewalSummary.map(value => value.buildAwsValue()))(
        _.renewalSummary
      )
      .optionallyWith(revocationReason.map(value => value.unwrap))(
        _.revocationReason
      )
      .optionallyWith(revokedAt.map(value => IsoDate.unwrap(value): Instant))(
        _.revokedAt
      )
      .optionallyWith(
        serial.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serial)
      .optionallyWith(
        signatureAlgorithm.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.signatureAlgorithm)
      .optionallyWith(
        subject.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subject)
      .optionallyWith(
        subjectAlternativeNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subjectAlternativeNames)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.LoadBalancerTlsCertificate.ReadOnly =
    zio.aws.lightsail.model.LoadBalancerTlsCertificate.wrap(buildAwsValue())
}
object LoadBalancerTlsCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.LoadBalancerTlsCertificate =
      zio.aws.lightsail.model.LoadBalancerTlsCertificate(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        loadBalancerName.map(value => value),
        isAttached.map(value => value),
        status.map(value => value),
        domainName.map(value => value),
        domainValidationRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failureReason.map(value => value),
        issuedAt.map(value => value),
        issuer.map(value => value),
        keyAlgorithm.map(value => value),
        notAfter.map(value => value),
        notBefore.map(value => value),
        renewalSummary.map(value => value.asEditable),
        revocationReason.map(value => value),
        revokedAt.map(value => value),
        serial.map(value => value),
        signatureAlgorithm.map(value => value),
        subject.map(value => value),
        subjectAlternativeNames.map(value => value)
      )
    def name: Option[ResourceName]
    def arn: Option[NonEmptyString]
    def supportCode: Option[String]
    def createdAt: Option[IsoDate]
    def location: Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def loadBalancerName: Option[ResourceName]
    def isAttached: Option[Boolean]
    def status: Option[zio.aws.lightsail.model.LoadBalancerTlsCertificateStatus]
    def domainName: Option[DomainName]
    def domainValidationRecords: Option[List[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly
    ]]
    def failureReason: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateFailureReason
    ]
    def issuedAt: Option[IsoDate]
    def issuer: Option[NonEmptyString]
    def keyAlgorithm: Option[NonEmptyString]
    def notAfter: Option[IsoDate]
    def notBefore: Option[IsoDate]
    def renewalSummary: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.ReadOnly
    ]
    def revocationReason: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRevocationReason
    ]
    def revokedAt: Option[IsoDate]
    def serial: Option[NonEmptyString]
    def signatureAlgorithm: Option[NonEmptyString]
    def subject: Option[NonEmptyString]
    def subjectAlternativeNames: Option[List[String]]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLoadBalancerName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getIsAttached: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAttached", isAttached)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.LoadBalancerTlsCertificateStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getDomainValidationRecords: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationRecords",
      domainValidationRecords
    )
    def getFailureReason: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.LoadBalancerTlsCertificateFailureReason
    ] = AwsError.unwrapOptionField("failureReason", failureReason)
    def getIssuedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("issuedAt", issuedAt)
    def getIssuer: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("issuer", issuer)
    def getKeyAlgorithm: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyAlgorithm", keyAlgorithm)
    def getNotAfter: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notAfter", notAfter)
    def getNotBefore: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getRenewalSummary: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.ReadOnly
    ] = AwsError.unwrapOptionField("renewalSummary", renewalSummary)
    def getRevocationReason: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRevocationReason
    ] = AwsError.unwrapOptionField("revocationReason", revocationReason)
    def getRevokedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("revokedAt", revokedAt)
    def getSerial: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serial", serial)
    def getSignatureAlgorithm: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("signatureAlgorithm", signatureAlgorithm)
    def getSubject: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subject", subject)
    def getSubjectAlternativeNames: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("subjectAlternativeNames", subjectAlternativeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate
  ) extends zio.aws.lightsail.model.LoadBalancerTlsCertificate.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val loadBalancerName: Option[ResourceName] = scala
      .Option(impl.loadBalancerName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val isAttached: Option[Boolean] =
      scala.Option(impl.isAttached()).map(value => value: Boolean)
    override val status
        : Option[zio.aws.lightsail.model.LoadBalancerTlsCertificateStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.lightsail.model.LoadBalancerTlsCertificateStatus.wrap(value)
        )
    override val domainName: Option[DomainName] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.lightsail.model.primitives.DomainName(value))
    override val domainValidationRecords: Option[List[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly
    ]] = scala
      .Option(impl.domainValidationRecords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
            .wrap(item)
        }.toList
      )
    override val failureReason: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateFailureReason
    ] = scala
      .Option(impl.failureReason())
      .map(value =>
        zio.aws.lightsail.model.LoadBalancerTlsCertificateFailureReason
          .wrap(value)
      )
    override val issuedAt: Option[IsoDate] = scala
      .Option(impl.issuedAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val issuer: Option[NonEmptyString] = scala
      .Option(impl.issuer())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val keyAlgorithm: Option[NonEmptyString] = scala
      .Option(impl.keyAlgorithm())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val notAfter: Option[IsoDate] = scala
      .Option(impl.notAfter())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val notBefore: Option[IsoDate] = scala
      .Option(impl.notBefore())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val renewalSummary: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.ReadOnly
    ] = scala
      .Option(impl.renewalSummary())
      .map(value =>
        zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
          .wrap(value)
      )
    override val revocationReason: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRevocationReason
    ] = scala
      .Option(impl.revocationReason())
      .map(value =>
        zio.aws.lightsail.model.LoadBalancerTlsCertificateRevocationReason
          .wrap(value)
      )
    override val revokedAt: Option[IsoDate] = scala
      .Option(impl.revokedAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val serial: Option[NonEmptyString] = scala
      .Option(impl.serial())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val signatureAlgorithm: Option[NonEmptyString] = scala
      .Option(impl.signatureAlgorithm())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val subject: Option[NonEmptyString] = scala
      .Option(impl.subject())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val subjectAlternativeNames: Option[List[String]] = scala
      .Option(impl.subjectAlternativeNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate
  ): zio.aws.lightsail.model.LoadBalancerTlsCertificate.ReadOnly = new Wrapper(
    impl
  )
}
