package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{DomainName, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoadBalancerTlsCertificateDomainValidationRecord(
    name: Option[NonEmptyString] = None,
    `type`: Option[NonEmptyString] = None,
    value: Option[NonEmptyString] = None,
    validationStatus: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ] = None,
    domainName: Option[DomainName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord = {
    import LoadBalancerTlsCertificateDomainValidationRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(validationStatus.map(value => value.unwrap))(
        _.validationStatus
      )
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly =
    zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
      .wrap(buildAwsValue())
}
object LoadBalancerTlsCertificateDomainValidationRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord =
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord(
        name.map(value => value),
        `type`.map(value => value),
        value.map(value => value),
        validationStatus.map(value => value),
        domainName.map(value => value)
      )
    def name: Option[NonEmptyString]
    def `type`: Option[NonEmptyString]
    def value: Option[NonEmptyString]
    def validationStatus
        : Option[zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainStatus]
    def domainName: Option[DomainName]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
    def getValidationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ] = AwsError.unwrapOptionField("validationStatus", validationStatus)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
  ) extends zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly {
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val value: Option[NonEmptyString] = scala
      .Option(impl.value())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val validationStatus: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ] = scala
      .Option(impl.validationStatus())
      .map(value =>
        zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
          .wrap(value)
      )
    override val domainName: Option[DomainName] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.lightsail.model.primitives.DomainName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
  ): zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly =
    new Wrapper(impl)
}
