package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.IsoDate
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class LogEvent(
    createdAt: Option[IsoDate] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LogEvent = {
    import LogEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LogEvent
      .builder()
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.LogEvent.ReadOnly =
    zio.aws.lightsail.model.LogEvent.wrap(buildAwsValue())
}
object LogEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LogEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.LogEvent = zio.aws.lightsail.model
      .LogEvent(createdAt.map(value => value), message.map(value => value))
    def createdAt: Option[IsoDate]
    def message: Option[String]
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LogEvent
  ) extends zio.aws.lightsail.model.LogEvent.ReadOnly {
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LogEvent
  ): zio.aws.lightsail.model.LogEvent.ReadOnly = new Wrapper(impl)
}
