package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{ResourceName, ResourceArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MonitoredResourceInfo(
    arn: Option[ResourceArn] = None,
    name: Option[ResourceName] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo = {
    import MonitoredResourceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo
      .builder()
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.MonitoredResourceInfo.ReadOnly =
    zio.aws.lightsail.model.MonitoredResourceInfo.wrap(buildAwsValue())
}
object MonitoredResourceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.MonitoredResourceInfo =
      zio.aws.lightsail.model.MonitoredResourceInfo(
        arn.map(value => value),
        name.map(value => value),
        resourceType.map(value => value)
      )
    def arn: Option[ResourceArn]
    def name: Option[ResourceName]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo
  ) extends zio.aws.lightsail.model.MonitoredResourceInfo.ReadOnly {
    override val arn: Option[ResourceArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.ResourceArn(value))
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo
  ): zio.aws.lightsail.model.MonitoredResourceInfo.ReadOnly = new Wrapper(impl)
}
