package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PasswordData(
    ciphertext: Option[String] = None,
    keyPairName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.PasswordData = {
    import PasswordData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PasswordData
      .builder()
      .optionallyWith(ciphertext.map(value => value: java.lang.String))(
        _.ciphertext
      )
      .optionallyWith(
        keyPairName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.keyPairName)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.PasswordData.ReadOnly =
    zio.aws.lightsail.model.PasswordData.wrap(buildAwsValue())
}
object PasswordData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.PasswordData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.PasswordData =
      zio.aws.lightsail.model.PasswordData(
        ciphertext.map(value => value),
        keyPairName.map(value => value)
      )
    def ciphertext: Option[String]
    def keyPairName: Option[ResourceName]
    def getCiphertext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ciphertext", ciphertext)
    def getKeyPairName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("keyPairName", keyPairName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.PasswordData
  ) extends zio.aws.lightsail.model.PasswordData.ReadOnly {
    override val ciphertext: Option[String] =
      scala.Option(impl.ciphertext()).map(value => value: String)
    override val keyPairName: Option[ResourceName] = scala
      .Option(impl.keyPairName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.PasswordData
  ): zio.aws.lightsail.model.PasswordData.ReadOnly = new Wrapper(impl)
}
