package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PendingModifiedRelationalDatabaseValues(
    masterUserPassword: Option[String] = None,
    engineVersion: Option[String] = None,
    backupRetentionEnabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues = {
    import PendingModifiedRelationalDatabaseValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues
      .builder()
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        backupRetentionEnabled.map(value => value: java.lang.Boolean)
      )(_.backupRetentionEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly =
    zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues
      .wrap(buildAwsValue())
}
object PendingModifiedRelationalDatabaseValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues =
      zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues(
        masterUserPassword.map(value => value),
        engineVersion.map(value => value),
        backupRetentionEnabled.map(value => value)
      )
    def masterUserPassword: Option[String]
    def engineVersion: Option[String]
    def backupRetentionEnabled: Option[Boolean]
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getBackupRetentionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("backupRetentionEnabled", backupRetentionEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues
  ) extends zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly {
    override val masterUserPassword: Option[String] =
      scala.Option(impl.masterUserPassword()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val backupRetentionEnabled: Option[Boolean] =
      scala.Option(impl.backupRetentionEnabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues
  ): zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly =
    new Wrapper(impl)
}
