package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class QueryStringObject(
    option: Option[Boolean] = None,
    queryStringsAllowList: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.QueryStringObject = {
    import QueryStringObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.QueryStringObject
      .builder()
      .optionallyWith(option.map(value => value: java.lang.Boolean))(_.option)
      .optionallyWith(
        queryStringsAllowList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.queryStringsAllowList)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.QueryStringObject.ReadOnly =
    zio.aws.lightsail.model.QueryStringObject.wrap(buildAwsValue())
}
object QueryStringObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.QueryStringObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.QueryStringObject =
      zio.aws.lightsail.model.QueryStringObject(
        option.map(value => value),
        queryStringsAllowList.map(value => value)
      )
    def option: Option[Boolean]
    def queryStringsAllowList: Option[List[String]]
    def getOption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("option", option)
    def getQueryStringsAllowList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("queryStringsAllowList", queryStringsAllowList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.QueryStringObject
  ) extends zio.aws.lightsail.model.QueryStringObject.ReadOnly {
    override val option: Option[Boolean] =
      scala.Option(impl.option()).map(value => value: Boolean)
    override val queryStringsAllowList: Option[List[String]] = scala
      .Option(impl.queryStringsAllowList())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.QueryStringObject
  ): zio.aws.lightsail.model.QueryStringObject.ReadOnly = new Wrapper(impl)
}
