package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class RelationalDatabase(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[zio.aws.lightsail.model.ResourceLocation] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None,
    relationalDatabaseBlueprintId: Option[NonEmptyString] = None,
    relationalDatabaseBundleId: Option[NonEmptyString] = None,
    masterDatabaseName: Option[String] = None,
    hardware: Option[zio.aws.lightsail.model.RelationalDatabaseHardware] = None,
    state: Option[NonEmptyString] = None,
    secondaryAvailabilityZone: Option[String] = None,
    backupRetentionEnabled: Option[Boolean] = None,
    pendingModifiedValues: Option[
      zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues
    ] = None,
    engine: Option[NonEmptyString] = None,
    engineVersion: Option[NonEmptyString] = None,
    latestRestorableTime: Option[IsoDate] = None,
    masterUsername: Option[NonEmptyString] = None,
    parameterApplyStatus: Option[NonEmptyString] = None,
    preferredBackupWindow: Option[NonEmptyString] = None,
    preferredMaintenanceWindow: Option[NonEmptyString] = None,
    publiclyAccessible: Option[Boolean] = None,
    masterEndpoint: Option[zio.aws.lightsail.model.RelationalDatabaseEndpoint] =
      None,
    pendingMaintenanceActions: Option[
      Iterable[zio.aws.lightsail.model.PendingMaintenanceAction]
    ] = None,
    caCertificateIdentifier: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabase = {
    import RelationalDatabase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabase
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        relationalDatabaseBlueprintId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.relationalDatabaseBlueprintId)
      .optionallyWith(
        relationalDatabaseBundleId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.relationalDatabaseBundleId)
      .optionallyWith(masterDatabaseName.map(value => value: java.lang.String))(
        _.masterDatabaseName
      )
      .optionallyWith(hardware.map(value => value.buildAwsValue()))(_.hardware)
      .optionallyWith(
        state.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(
        secondaryAvailabilityZone.map(value => value: java.lang.String)
      )(_.secondaryAvailabilityZone)
      .optionallyWith(
        backupRetentionEnabled.map(value => value: java.lang.Boolean)
      )(_.backupRetentionEnabled)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        engine.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.engine)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        latestRestorableTime.map(value => IsoDate.unwrap(value): Instant)
      )(_.latestRestorableTime)
      .optionallyWith(
        masterUsername.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUsername)
      .optionallyWith(
        parameterApplyStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.parameterApplyStatus)
      .optionallyWith(
        preferredBackupWindow.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(masterEndpoint.map(value => value.buildAwsValue()))(
        _.masterEndpoint
      )
      .optionallyWith(
        pendingMaintenanceActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingMaintenanceActions)
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.RelationalDatabase.ReadOnly =
    zio.aws.lightsail.model.RelationalDatabase.wrap(buildAwsValue())
}
object RelationalDatabase {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabase
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RelationalDatabase =
      zio.aws.lightsail.model.RelationalDatabase(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relationalDatabaseBlueprintId.map(value => value),
        relationalDatabaseBundleId.map(value => value),
        masterDatabaseName.map(value => value),
        hardware.map(value => value.asEditable),
        state.map(value => value),
        secondaryAvailabilityZone.map(value => value),
        backupRetentionEnabled.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        engine.map(value => value),
        engineVersion.map(value => value),
        latestRestorableTime.map(value => value),
        masterUsername.map(value => value),
        parameterApplyStatus.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        publiclyAccessible.map(value => value),
        masterEndpoint.map(value => value.asEditable),
        pendingMaintenanceActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        caCertificateIdentifier.map(value => value)
      )
    def name: Option[ResourceName]
    def arn: Option[NonEmptyString]
    def supportCode: Option[String]
    def createdAt: Option[IsoDate]
    def location: Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def relationalDatabaseBlueprintId: Option[NonEmptyString]
    def relationalDatabaseBundleId: Option[NonEmptyString]
    def masterDatabaseName: Option[String]
    def hardware
        : Option[zio.aws.lightsail.model.RelationalDatabaseHardware.ReadOnly]
    def state: Option[NonEmptyString]
    def secondaryAvailabilityZone: Option[String]
    def backupRetentionEnabled: Option[Boolean]
    def pendingModifiedValues: Option[
      zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly
    ]
    def engine: Option[NonEmptyString]
    def engineVersion: Option[NonEmptyString]
    def latestRestorableTime: Option[IsoDate]
    def masterUsername: Option[NonEmptyString]
    def parameterApplyStatus: Option[NonEmptyString]
    def preferredBackupWindow: Option[NonEmptyString]
    def preferredMaintenanceWindow: Option[NonEmptyString]
    def publiclyAccessible: Option[Boolean]
    def masterEndpoint
        : Option[zio.aws.lightsail.model.RelationalDatabaseEndpoint.ReadOnly]
    def pendingMaintenanceActions: Option[
      List[zio.aws.lightsail.model.PendingMaintenanceAction.ReadOnly]
    ]
    def caCertificateIdentifier: Option[String]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRelationalDatabaseBlueprintId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "relationalDatabaseBlueprintId",
        relationalDatabaseBlueprintId
      )
    def getRelationalDatabaseBundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "relationalDatabaseBundleId",
        relationalDatabaseBundleId
      )
    def getMasterDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterDatabaseName", masterDatabaseName)
    def getHardware: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.RelationalDatabaseHardware.ReadOnly
    ] = AwsError.unwrapOptionField("hardware", hardware)
    def getState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", state)
    def getSecondaryAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secondaryAvailabilityZone", secondaryAvailabilityZone)
    def getBackupRetentionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("backupRetentionEnabled", backupRetentionEnabled)
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getEngine: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLatestRestorableTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTime)
    def getMasterUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getParameterApplyStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("parameterApplyStatus", parameterApplyStatus)
    def getPreferredBackupWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getMasterEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.RelationalDatabaseEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("masterEndpoint", masterEndpoint)
    def getPendingMaintenanceActions: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.PendingMaintenanceAction.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pendingMaintenanceActions",
      pendingMaintenanceActions
    )
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabase
  ) extends zio.aws.lightsail.model.RelationalDatabase.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val relationalDatabaseBlueprintId: Option[NonEmptyString] = scala
      .Option(impl.relationalDatabaseBlueprintId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val relationalDatabaseBundleId: Option[NonEmptyString] = scala
      .Option(impl.relationalDatabaseBundleId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val masterDatabaseName: Option[String] =
      scala.Option(impl.masterDatabaseName()).map(value => value: String)
    override val hardware
        : Option[zio.aws.lightsail.model.RelationalDatabaseHardware.ReadOnly] =
      scala
        .Option(impl.hardware())
        .map(value =>
          zio.aws.lightsail.model.RelationalDatabaseHardware.wrap(value)
        )
    override val state: Option[NonEmptyString] = scala
      .Option(impl.state())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val secondaryAvailabilityZone: Option[String] =
      scala.Option(impl.secondaryAvailabilityZone()).map(value => value: String)
    override val backupRetentionEnabled: Option[Boolean] =
      scala.Option(impl.backupRetentionEnabled()).map(value => value: Boolean)
    override val pendingModifiedValues: Option[
      zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly
    ] = scala
      .Option(impl.pendingModifiedValues())
      .map(value =>
        zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues
          .wrap(value)
      )
    override val engine: Option[NonEmptyString] = scala
      .Option(impl.engine())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val engineVersion: Option[NonEmptyString] = scala
      .Option(impl.engineVersion())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val latestRestorableTime: Option[IsoDate] = scala
      .Option(impl.latestRestorableTime())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val masterUsername: Option[NonEmptyString] = scala
      .Option(impl.masterUsername())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val parameterApplyStatus: Option[NonEmptyString] = scala
      .Option(impl.parameterApplyStatus())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val preferredBackupWindow: Option[NonEmptyString] = scala
      .Option(impl.preferredBackupWindow())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val preferredMaintenanceWindow: Option[NonEmptyString] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val publiclyAccessible: Option[Boolean] =
      scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override val masterEndpoint
        : Option[zio.aws.lightsail.model.RelationalDatabaseEndpoint.ReadOnly] =
      scala
        .Option(impl.masterEndpoint())
        .map(value =>
          zio.aws.lightsail.model.RelationalDatabaseEndpoint.wrap(value)
        )
    override val pendingMaintenanceActions: Option[
      List[zio.aws.lightsail.model.PendingMaintenanceAction.ReadOnly]
    ] = scala
      .Option(impl.pendingMaintenanceActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.PendingMaintenanceAction.wrap(item)
        }.toList
      )
    override val caCertificateIdentifier: Option[String] =
      scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabase
  ): zio.aws.lightsail.model.RelationalDatabase.ReadOnly = new Wrapper(impl)
}
