package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RelationalDatabaseBlueprint(
    blueprintId: Option[String] = None,
    engine: Option[zio.aws.lightsail.model.RelationalDatabaseEngine] = None,
    engineVersion: Option[String] = None,
    engineDescription: Option[String] = None,
    engineVersionDescription: Option[String] = None,
    isEngineDefault: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint = {
    import RelationalDatabaseBlueprint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint
      .builder()
      .optionallyWith(blueprintId.map(value => value: java.lang.String))(
        _.blueprintId
      )
      .optionallyWith(engine.map(value => value.unwrap))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(engineDescription.map(value => value: java.lang.String))(
        _.engineDescription
      )
      .optionallyWith(
        engineVersionDescription.map(value => value: java.lang.String)
      )(_.engineVersionDescription)
      .optionallyWith(isEngineDefault.map(value => value: java.lang.Boolean))(
        _.isEngineDefault
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly =
    zio.aws.lightsail.model.RelationalDatabaseBlueprint.wrap(buildAwsValue())
}
object RelationalDatabaseBlueprint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RelationalDatabaseBlueprint =
      zio.aws.lightsail.model.RelationalDatabaseBlueprint(
        blueprintId.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        engineDescription.map(value => value),
        engineVersionDescription.map(value => value),
        isEngineDefault.map(value => value)
      )
    def blueprintId: Option[String]
    def engine: Option[zio.aws.lightsail.model.RelationalDatabaseEngine]
    def engineVersion: Option[String]
    def engineDescription: Option[String]
    def engineVersionDescription: Option[String]
    def isEngineDefault: Option[Boolean]
    def getBlueprintId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("blueprintId", blueprintId)
    def getEngine
        : ZIO[Any, AwsError, zio.aws.lightsail.model.RelationalDatabaseEngine] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getEngineDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineDescription", engineDescription)
    def getEngineVersionDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("engineVersionDescription", engineVersionDescription)
    def getIsEngineDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEngineDefault", isEngineDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint
  ) extends zio.aws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly {
    override val blueprintId: Option[String] =
      scala.Option(impl.blueprintId()).map(value => value: String)
    override val engine
        : Option[zio.aws.lightsail.model.RelationalDatabaseEngine] = scala
      .Option(impl.engine())
      .map(value =>
        zio.aws.lightsail.model.RelationalDatabaseEngine.wrap(value)
      )
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val engineDescription: Option[String] =
      scala.Option(impl.engineDescription()).map(value => value: String)
    override val engineVersionDescription: Option[String] =
      scala.Option(impl.engineVersionDescription()).map(value => value: String)
    override val isEngineDefault: Option[Boolean] =
      scala.Option(impl.isEngineDefault()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint
  ): zio.aws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly = new Wrapper(
    impl
  )
}
