package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RelationalDatabaseHardware(
    cpuCount: Option[Integer] = None,
    diskSizeInGb: Option[Integer] = None,
    ramSizeInGb: Option[Float] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware = {
    import RelationalDatabaseHardware.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware
      .builder()
      .optionallyWith(
        cpuCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.cpuCount)
      .optionallyWith(
        diskSizeInGb.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.diskSizeInGb)
      .optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(
        _.ramSizeInGb
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.RelationalDatabaseHardware.ReadOnly =
    zio.aws.lightsail.model.RelationalDatabaseHardware.wrap(buildAwsValue())
}
object RelationalDatabaseHardware {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RelationalDatabaseHardware =
      zio.aws.lightsail.model.RelationalDatabaseHardware(
        cpuCount.map(value => value),
        diskSizeInGb.map(value => value),
        ramSizeInGb.map(value => value)
      )
    def cpuCount: Option[Integer]
    def diskSizeInGb: Option[Integer]
    def ramSizeInGb: Option[Float]
    def getCpuCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cpuCount", cpuCount)
    def getDiskSizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("diskSizeInGb", diskSizeInGb)
    def getRamSizeInGb: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGb)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware
  ) extends zio.aws.lightsail.model.RelationalDatabaseHardware.ReadOnly {
    override val cpuCount: Option[Integer] = scala
      .Option(impl.cpuCount())
      .map(value => zio.aws.lightsail.model.primitives.Integer(value))
    override val diskSizeInGb: Option[Integer] = scala
      .Option(impl.diskSizeInGb())
      .map(value => zio.aws.lightsail.model.primitives.Integer(value))
    override val ramSizeInGb: Option[Float] =
      scala.Option(impl.ramSizeInGb()).map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware
  ): zio.aws.lightsail.model.RelationalDatabaseHardware.ReadOnly = new Wrapper(
    impl
  )
}
