package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResourceLocation(
    availabilityZone: Option[String] = None,
    regionName: Option[zio.aws.lightsail.model.RegionName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ResourceLocation = {
    import ResourceLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ResourceLocation
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(regionName.map(value => value.unwrap))(_.regionName)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ResourceLocation.ReadOnly =
    zio.aws.lightsail.model.ResourceLocation.wrap(buildAwsValue())
}
object ResourceLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ResourceLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ResourceLocation =
      zio.aws.lightsail.model.ResourceLocation(
        availabilityZone.map(value => value),
        regionName.map(value => value)
      )
    def availabilityZone: Option[String]
    def regionName: Option[zio.aws.lightsail.model.RegionName]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getRegionName: ZIO[Any, AwsError, zio.aws.lightsail.model.RegionName] =
      AwsError.unwrapOptionField("regionName", regionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ResourceLocation
  ) extends zio.aws.lightsail.model.ResourceLocation.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val regionName: Option[zio.aws.lightsail.model.RegionName] = scala
      .Option(impl.regionName())
      .map(value => zio.aws.lightsail.model.RegionName.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ResourceLocation
  ): zio.aws.lightsail.model.ResourceLocation.ReadOnly = new Wrapper(impl)
}
