package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResourceReceivingAccess(
    name: Option[NonEmptyString] = None,
    resourceType: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess = {
    import ResourceReceivingAccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        resourceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ResourceReceivingAccess.ReadOnly =
    zio.aws.lightsail.model.ResourceReceivingAccess.wrap(buildAwsValue())
}
object ResourceReceivingAccess {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ResourceReceivingAccess =
      zio.aws.lightsail.model.ResourceReceivingAccess(
        name.map(value => value),
        resourceType.map(value => value)
      )
    def name: Option[NonEmptyString]
    def resourceType: Option[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getResourceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess
  ) extends zio.aws.lightsail.model.ResourceReceivingAccess.ReadOnly {
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val resourceType: Option[NonEmptyString] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ResourceReceivingAccess
  ): zio.aws.lightsail.model.ResourceReceivingAccess.ReadOnly = new Wrapper(
    impl
  )
}
