package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UntagResourceResponse(
    operations: Option[Iterable[zio.aws.lightsail.model.Operation]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UntagResourceResponse = {
    import UntagResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UntagResourceResponse
      .builder()
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.UntagResourceResponse.ReadOnly =
    zio.aws.lightsail.model.UntagResourceResponse.wrap(buildAwsValue())
}
object UntagResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UntagResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.UntagResourceResponse =
      zio.aws.lightsail.model.UntagResourceResponse(
        operations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def operations: Option[List[zio.aws.lightsail.model.Operation.ReadOnly]]
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      AwsError.unwrapOptionField("operations", operations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UntagResourceResponse
  ) extends zio.aws.lightsail.model.UntagResourceResponse.ReadOnly {
    override val operations
        : Option[List[zio.aws.lightsail.model.Operation.ReadOnly]] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.Operation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UntagResourceResponse
  ): zio.aws.lightsail.model.UntagResourceResponse.ReadOnly = new Wrapper(impl)
}
