package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateBucketResponse(
    bucket: Option[zio.aws.lightsail.model.Bucket] = None,
    operations: Option[Iterable[zio.aws.lightsail.model.Operation]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse = {
    import UpdateBucketResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse
      .builder()
      .optionallyWith(bucket.map(value => value.buildAwsValue()))(_.bucket)
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.UpdateBucketResponse.ReadOnly =
    zio.aws.lightsail.model.UpdateBucketResponse.wrap(buildAwsValue())
}
object UpdateBucketResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.UpdateBucketResponse =
      zio.aws.lightsail.model.UpdateBucketResponse(
        bucket.map(value => value.asEditable),
        operations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def bucket: Option[zio.aws.lightsail.model.Bucket.ReadOnly]
    def operations: Option[List[zio.aws.lightsail.model.Operation.ReadOnly]]
    def getBucket: ZIO[Any, AwsError, zio.aws.lightsail.model.Bucket.ReadOnly] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      AwsError.unwrapOptionField("operations", operations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse
  ) extends zio.aws.lightsail.model.UpdateBucketResponse.ReadOnly {
    override val bucket: Option[zio.aws.lightsail.model.Bucket.ReadOnly] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.lightsail.model.Bucket.wrap(value))
    override val operations
        : Option[List[zio.aws.lightsail.model.Operation.ReadOnly]] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.Operation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse
  ): zio.aws.lightsail.model.UpdateBucketResponse.ReadOnly = new Wrapper(impl)
}
