package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDistributionBundleRequest(
    distributionName: Option[ResourceName] = None,
    bundleId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest = {
    import UpdateDistributionBundleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest
      .builder()
      .optionallyWith(
        distributionName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.distributionName)
      .optionallyWith(bundleId.map(value => value: java.lang.String))(
        _.bundleId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.UpdateDistributionBundleRequest.ReadOnly =
    zio.aws.lightsail.model.UpdateDistributionBundleRequest
      .wrap(buildAwsValue())
}
object UpdateDistributionBundleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.UpdateDistributionBundleRequest =
      zio.aws.lightsail.model.UpdateDistributionBundleRequest(
        distributionName.map(value => value),
        bundleId.map(value => value)
      )
    def distributionName: Option[ResourceName]
    def bundleId: Option[String]
    def getDistributionName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("distributionName", distributionName)
    def getBundleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bundleId", bundleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest
  ) extends zio.aws.lightsail.model.UpdateDistributionBundleRequest.ReadOnly {
    override val distributionName: Option[ResourceName] = scala
      .Option(impl.distributionName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val bundleId: Option[String] =
      scala.Option(impl.bundleId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest
  ): zio.aws.lightsail.model.UpdateDistributionBundleRequest.ReadOnly =
    new Wrapper(impl)
}
