package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{SensitiveString, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateRelationalDatabaseRequest(
    relationalDatabaseName: ResourceName,
    masterUserPassword: Option[SensitiveString] = None,
    rotateMasterUserPassword: Option[Boolean] = None,
    preferredBackupWindow: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    enableBackupRetention: Option[Boolean] = None,
    disableBackupRetention: Option[Boolean] = None,
    publiclyAccessible: Option[Boolean] = None,
    applyImmediately: Option[Boolean] = None,
    caCertificateIdentifier: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest = {
    import UpdateRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .optionallyWith(
        masterUserPassword.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.masterUserPassword)
      .optionallyWith(
        rotateMasterUserPassword.map(value => value: java.lang.Boolean)
      )(_.rotateMasterUserPassword)
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        enableBackupRetention.map(value => value: java.lang.Boolean)
      )(_.enableBackupRetention)
      .optionallyWith(
        disableBackupRetention.map(value => value: java.lang.Boolean)
      )(_.disableBackupRetention)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.UpdateRelationalDatabaseRequest.ReadOnly =
    zio.aws.lightsail.model.UpdateRelationalDatabaseRequest
      .wrap(buildAwsValue())
}
object UpdateRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.UpdateRelationalDatabaseRequest =
      zio.aws.lightsail.model.UpdateRelationalDatabaseRequest(
        relationalDatabaseName,
        masterUserPassword.map(value => value),
        rotateMasterUserPassword.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        enableBackupRetention.map(value => value),
        disableBackupRetention.map(value => value),
        publiclyAccessible.map(value => value),
        applyImmediately.map(value => value),
        caCertificateIdentifier.map(value => value)
      )
    def relationalDatabaseName: ResourceName
    def masterUserPassword: Option[SensitiveString]
    def rotateMasterUserPassword: Option[Boolean]
    def preferredBackupWindow: Option[String]
    def preferredMaintenanceWindow: Option[String]
    def enableBackupRetention: Option[Boolean]
    def disableBackupRetention: Option[Boolean]
    def publiclyAccessible: Option[Boolean]
    def applyImmediately: Option[Boolean]
    def caCertificateIdentifier: Option[String]
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
    def getMasterUserPassword: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getRotateMasterUserPassword: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("rotateMasterUserPassword", rotateMasterUserPassword)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getEnableBackupRetention: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableBackupRetention", enableBackupRetention)
    def getDisableBackupRetention: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("disableBackupRetention", disableBackupRetention)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest
  ) extends zio.aws.lightsail.model.UpdateRelationalDatabaseRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
    override val masterUserPassword: Option[SensitiveString] = scala
      .Option(impl.masterUserPassword())
      .map(value => zio.aws.lightsail.model.primitives.SensitiveString(value))
    override val rotateMasterUserPassword: Option[Boolean] =
      scala.Option(impl.rotateMasterUserPassword()).map(value => value: Boolean)
    override val preferredBackupWindow: Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val enableBackupRetention: Option[Boolean] =
      scala.Option(impl.enableBackupRetention()).map(value => value: Boolean)
    override val disableBackupRetention: Option[Boolean] =
      scala.Option(impl.disableBackupRetention()).map(value => value: Boolean)
    override val publiclyAccessible: Option[Boolean] =
      scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override val applyImmediately: Option[Boolean] =
      scala.Option(impl.applyImmediately()).map(value => value: Boolean)
    override val caCertificateIdentifier: Option[String] =
      scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest
  ): zio.aws.lightsail.model.UpdateRelationalDatabaseRequest.ReadOnly =
    new Wrapper(impl)
}
